<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

include 'include/head.php';
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Liste des professeurs (cliquez sur un nom pour modifier)
                        </div>
                        <!-- /.panel-heading -->
                        <div class="panel-body">
                            <div class="dataTable_wrapper">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                    <tr>
                                        <th>Nom</th>
                                        <th>Prénom</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $result = $bdd->query("SELECT * FROM professeur");
                                    while ( $ligne = $result->fetch())
                                    {
                                        ?>
                                        <tr class="odd">
                                            <td><a href="edition-professeur.php?id=<?php echo htmlspecialchars($ligne['id_professeur']) ?>"><?php echo htmlspecialchars($ligne['nom_professeur']) ?></a></td>
                                            <td><?php echo htmlspecialchars($ligne['prenom_professeur']) ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.panel-body -->
                    </div>
                    <!-- /.panel -->
                </div>
                <!-- /.col-lg-12 -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
